#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 vector
version:              0.13.1.0
visibility:           public
id:                   vector-0.13.1.0-Gf2urNiIAD32gZDiWE6SSZ
key:                  vector-0.13.1.0-Gf2urNiIAD32gZDiWE6SSZ
license:              BSD-3-Clause
copyright:
    (c) Roman Leshchinskiy 2008-2012,
    Alexey Kuleshevich 2020-2022,
    Aleksey Khudyakov 2020-2022,
    Andrew Lelechenko 2020-2022

maintainer:
    Haskell Libraries Team <libraries@haskell.org>
    Alexey Kuleshevich <alexey@kuleshevi.ch>,
    Aleksey Khudyakov <alexey.skladnoy@gmail.com>,
    Andrew Lelechenko <andrew.lelechenko@gmail.com>

author:               Roman Leshchinskiy <rl@cse.unsw.edu.au>
homepage:             https://github.com/haskell/vector
synopsis:             Efficient Arrays
description:

    An efficient implementation of @Int@-indexed arrays (both mutable
    and immutable), with a powerful loop optimisation framework .

    It is structured as follows:

    ["Data.Vector"] Boxed vectors of arbitrary types.

    ["Data.Vector.Unboxed"] Unboxed vectors with an adaptive
    representation based on data type families.

    ["Data.Vector.Storable"] Unboxed vectors of '\''Storable'\'' types.

    ["Data.Vector.Primitive"] Unboxed vectors of primitive types as
    defined by the @primitive@ package. "Data.Vector.Unboxed" is more
    flexible at no performance cost.

    ["Data.Vector.Generic"] Generic interface to the vector types.

    There is also a (draft) tutorial on common uses of vector.

    * <http://haskell.org/haskellwiki/Numeric_Haskell:_A_Vector_Tutorial>

category:             Data, Data Structures
abi:                  f811e559db2deabbfcd57b97fa15524c
exposed:              True
exposed-modules:
    Data.Vector Data.Vector.Fusion.Bundle
    Data.Vector.Fusion.Bundle.Monadic Data.Vector.Fusion.Bundle.Size
    Data.Vector.Fusion.Stream.Monadic Data.Vector.Fusion.Util
    Data.Vector.Generic Data.Vector.Generic.Base
    Data.Vector.Generic.Mutable Data.Vector.Generic.Mutable.Base
    Data.Vector.Generic.New Data.Vector.Internal.Check
    Data.Vector.Mutable Data.Vector.Primitive
    Data.Vector.Primitive.Mutable Data.Vector.Storable
    Data.Vector.Storable.Internal Data.Vector.Storable.Mutable
    Data.Vector.Unboxed Data.Vector.Unboxed.Base
    Data.Vector.Unboxed.Mutable

import-dirs:          /usr/lib/ghc-9.2.8/site-local/vector-0.13.1.0
library-dirs:         /usr/lib/ghc-9.2.8/site-local/vector-0.13.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-vector
hs-libraries:         HSvector-0.13.1.0-Gf2urNiIAD32gZDiWE6SSZ
include-dirs:         /usr/lib/ghc-9.2.8/site-local/vector-0.13.1.0/include
depends:
    base-4.16.4.0 deepseq-1.4.6.1
    primitive-0.7.4.0-I9XTAmFqErC1hXdXvvNzkS
    vector-stream-0.1.0.1-AnzbmjZCEugJDS2oIjCLpD

haddock-interfaces:   /usr/share/doc/haskell-vector/html/vector.haddock
haddock-html:         /usr/share/doc/haskell-vector/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

